/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.IOException;
import java.io.PrintWriter;
import org.autoplot.RenderType;
import org.autoplot.ScriptContext;
import org.autoplot.dom.Application;
import org.autoplot.dom.Row;
import org.autoplot.jythonsupport.Util;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;

public class Test002 {
    static long t0 = System.currentTimeMillis();

    public static void main(String[] args) {
        try {
            ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100%-10em");
            Test002.oldTests();
            Test002.testVaps();
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static void xxx(String id) {
        System.err.println("-- timer -- " + id + " --: " + (System.currentTimeMillis() - t0));
        t0 = System.currentTimeMillis();
        System.err.println("\n\n");
    }

    private static void doTest(String s, String label) throws IOException, InterruptedException, Exception {
        ScriptContext.load(s);
        int width = ScriptContext.getDocumentModel().getCanvases(0).getWidth();
        int height = ScriptContext.getDocumentModel().getCanvases(0).getHeight();
        ScriptContext.setCanvasSize(width, height);
        ScriptContext.writeToPng(label + ".png");
        if (label.equals("test002_009")) {
            System.err.println("Rows:");
            for (Row r : ScriptContext.getDocumentModel().getCanvases(0).getRows()) {
                System.err.println(r);
            }
            Thread.sleep(10000L);
            ScriptContext.load(s);
            System.err.println("after reload, Rows:");
            for (Row r : ScriptContext.getDocumentModel().getCanvases(0).getRows()) {
                System.err.println(r);
            }
            ScriptContext.writeToPng(label + ".png");
        }
        System.err.printf("wrote to %s.png %dx%d\n", label, width, height);
    }

    private static void testVaps() throws Exception {
        String[] uris;
        for (String s : uris = new String[]{"000 file:///home/jbf/ct/hudson/vap/lon/thb_l2_esa_20080907_electrons_less.vap", "001 file:///home/jbf/ct/hudson/vap/energyCompareHydra.vap", "003 file:///home/jbf/ct/hudson/vap/hydra4.vap", "004 file:///home/jbf/ct/hudson/vap/autoSlice.vap", "006 file:///home/jbf/ct/hudson/vap/omni_1978_v1_07.vap", "008 file:///home/jbf/ct/hudson/vap/lanl/lanlGeoEpDemo4.vap", "009 file:///home/jbf/ct/hudson/vap/ninePanels.vap", "010 http://autoplot.org/data/autoplot-applet.vap", "011 file:///home/jbf/ct/hudson/vap/twoConnectorsOneDataSource.v1_07.vap", "013 file:///home/jbf/ct/autoplot/demos/science/de_eics_species.vap", "015 file:///home/jbf/ct/autoplot/demos/polar.vap", "021 file:///home/jbf/ct/hudson/vap/auto4.v1_07.vap", "022 file:///home/jbf/ct/hudson/vap/tt2000.vap", "023 file:///home/jbf/ct/hudson/vap/seth/multiScheme.vap", "024 file:///home/jbf/ct/hudson/vap/demos/eventsBarForAvailability3.vap", "025 file:///home/jbf/ct/hudson/vap/seth/mageis_rank2_labels.vap", "028 vap+inline:x=[10,20,30,40,50,60,70,80,90]&y=[1,5,2,4,2,5,2,3,2]&x,y&RENDER_TYPE=stairSteps>fillColor=silver"}) {
            int count = Integer.parseInt(s.substring(0, 4).trim());
            s = s.substring(4);
            System.err.printf("=== test002_%03d %s ===\n", count, s);
            String label = String.format("test002_%03d", count);
            try {
                Test002.doTest(s, label);
            }
            catch (Exception ex) {
                PrintWriter pw = new PrintWriter(label + ".error");
                pw.println(s);
                pw.println("");
                ex.printStackTrace(pw);
                pw.close();
                ex.printStackTrace();
            }
            Test002.xxx(label + ": " + s);
        }
    }

    private static void oldTests() throws Exception, IOException, InterruptedException {
        QDataSet ds = Util.getDataSet((String)"file:///home/jbf/ct/hudson/data.backup/wav/fireworks.wav");
        Application dom = ScriptContext.getDocumentModel();
        dom.getCanvases(0).setFitted(false);
        ScriptContext.setCanvasSize(400, 800);
        ScriptContext.plot(0, Ops.autoHistogram((QDataSet)ds));
        dom.getPlots(0).getXaxis().getController().getDasAxis().setUseDomainDivider(true);
        dom.getPlotElements(0).setRenderType(RenderType.fillToZero);
        dom.getPlots(0).getYaxis().setLabel("auto histogram of!chttp://www.autoplot.org/data/fireworks.wav");
        QDataSet ds2 = Ops.autoHistogram((QDataSet)Ops.log10((QDataSet)Ops.fftWindow((QDataSet)ds, (int)512)));
        ScriptContext.plot(1, ds2);
        dom.getPlots(1).getXaxis().getController().getDasAxis().setUseDomainDivider(true);
        dom.getPlotElements(1).setRenderType(RenderType.fillToZero);
        dom.getPlots(1).getYaxis().setLabel("auto histogram of!cpower spectrum");
        dom.getPlots(1).getXaxis().setLabel("log(Ops.fftWindow(512)");
        ScriptContext.writeToPng("test002.png");
    }
}

